#pragma once

#include <openplx/OutputHandler.h>
#include <memory>
#include <string>
#include <optional>
#include <agx/Vec3.h>

namespace openplx {
    class Marshalling;

    namespace Physics::Signals {
        class Input;
        class Output;
        class AngleOutput;
    }

    namespace Physics3D::Bodies {
        class RigidBody;
    }

    namespace Physics3D::Signals {
        class Position3DOutput;
    }

    namespace Physics3D::Interactions {
        class Hinge;
    }
}

namespace agxopenplx {

    class AgxObjectMap;
    class AgxMetadata;

    template <class OutputT, typename FieldT, class... ModelT>
    class GenericOutputHandler : public openplx::OutputHandler {
        public:
            GenericOutputHandler(
                std::shared_ptr<AgxObjectMap> mapper,
                std::string field_key
            );

            bool handle(
                const std::shared_ptr<openplx::Physics::Signals::Output>& output,
                const std::shared_ptr<openplx::Marshalling>& marshalling) override;

            template <class ReadModelT>
            std::optional<FieldT> read(
                const std::shared_ptr<OutputT>& output,
                const std::shared_ptr<ReadModelT>& model);

        private:
            std::shared_ptr<AgxObjectMap> m_mapper;
            std::string m_field_key;
    };

    using AngleOutputHandler = GenericOutputHandler<
        openplx::Physics::Signals::AngleOutput,
        double,
        openplx::Physics3D::Interactions::Hinge
    >;

    using Position3DOutputHandler = GenericOutputHandler<
        openplx::Physics3D::Signals::Position3DOutput,
        agx::Vec3,
        openplx::Physics3D::Bodies::RigidBody
    >;
}
