/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxPowerLine/PowerLine.h>
#include <agxSDK/EventManager.h>
#include <agxSDK/StepEventListener.h>
#include <agxOpenPLX/AgxMetadata.h>
#include <agxOpenPLX/SignalQueue.h>
#include <agxOpenPLX/export.h>

#include <openplx/Simulation/Simulation_all.h>

namespace agxopenplx
{
  class AgxObjectMap;
  class InputHandler;

  /**
   * @brief Propagates input openplx signals to AGX
   */
  class AGXOPENPLX_EXPORT InputSignalListener : public agxSDK::StepEventListener
  {
    public:
      InputSignalListener(
        std::shared_ptr<InputSignalQueue> input_queue, std::shared_ptr<AgxObjectMap> mapper,
        std::shared_ptr<AgxMetadata> metadata);

      void preCollide(const agx::TimeStamp& time) override;

      /**
       * @brief Prefer this prio when adding InputSignalListener to an AGX Simulation
       *
       * Must run very early so that signals exists when other StepEventListeners that depend on Signals are invoked
       *
       */
      static constexpr int RECOMMENDED_PRIO = agxSDK::EventManager::ExecutePriority::HIGHEST_PRIORITY - 1;

      /**
       * Give prio SEND_SIGNAL_PRIO to any StepEventListeners that need to send signals
       * or for any other reason need to be invoked before InputSignalListener
       */
      static constexpr int SEND_SIGNAL_PRIO = agxSDK::EventManager::ExecutePriority::HIGHEST_PRIORITY;

      void addNotification() override;

      std::shared_ptr<InputSignalQueue> getQueue() const;

    private:
      std::shared_ptr<InputSignalQueue> m_input_queue;
      std::shared_ptr<AgxObjectMap> m_mapper;
      std::shared_ptr<InputHandler> m_input_handler;
  };
}
