#pragma once

#include <memory>
#include <vector>
#include <agxOSG/ExampleApplication.h>
#include <click/Server.h>
#include <openplx/Object.h>
#include <openplx/Robotics/Signals/RobotInput.h>
#include <openplx/Simulation/Simulation_all.h>
#include <agxOpenPLX/ClickInputListener.h>

namespace agxopenplx {

/**
 * @brief Propagates Click input signals to openplx
 * Inherits ExampleApplicationListener since Click messages can arrive even though the simulation is stopped.
 * Add to ExampleApplication, e.g
 * \code
 * ClickInputListener* click_input_listener = new ClickInputListener(server, scene, autostepping_enabled);
 * app->addListener(click_input_listener)
 * \endcode
 *
 * @see ClickKeyboardEventListener which makes sure we still can use -p cmdline and r key to step the simulation,
 * even though we use Autostepping in the implementation to wait for Click messages before next step.
 */
class AGXOSG_EXPORT OsgClickInputListener: public agxOSG::ExampleApplicationListener, public ClickInputListener {

    public:
        OsgClickInputListener(std::shared_ptr<click::Server>& server,
                              const std::shared_ptr<openplx::Core::Object>& openplx_scene,
                              std::shared_ptr<InputSignalQueue> input_queue,
                              double time_step,
                              bool autostepping_enabled);

        void preFrame(agxOSG::ExampleApplication* app) override;

        void autostepOffCallback() override;
        void autostepOnCallback() override;
        void stopApplicationCallback() override;
        void resetCallback() override;

    private:
        using ClickInputListener::preFrame;
        agxOSG::ExampleApplication* m_app;
};
}
