/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once

/**
\page Tutorials Tutorials

\section tutoriallist C++ Tutorials
- \ref tutorial_agxPlot
- \ref tutorial_agxTerrain
- \ref tutorial_agxTerrain_ClamShellBucket
- \ref tutorial_ballJoint_secondaryConstraints
- \ref tutorial_basicSimulation
- \ref tutorial_beam
- \ref tutorial_bodies
- \ref tutorial_bulldozer_with_terrain
- \ref tutorial_cable
- \ref tutorial_cableWindAndWater
- \ref tutorial_cable_damage
- \ref tutorial_cable_tunneling_guard
- \ref tutorial_car
- \ref tutorial_carSteering
- \ref tutorial_centerOfBuoyancy
- \ref tutorial_collisionDetection
- \ref tutorial_constraints
- \ref tutorial_contactForces
- \ref tutorial_contactMeasurement
- \ref tutorial_convex
- \ref tutorial_conveyorBelts
- \ref tutorial_create_oriented_bounding_volume
- \ref tutorial_customConstraints
- \ref tutorial_customMergeSplitAlgorithm
- \ref tutorial_driveTrain
- \ref tutorial_driveTrain_ElectricMotor
- \ref tutorial_driveTrain_combustionEngine
- \ref tutorial_encoder
- \ref tutorial_energyManager
- \ref tutorial_fracture
- \ref tutorial_frictionModels
- \ref tutorial_gamePad
- \ref tutorial_granularBodies
- \ref tutorial_gravityFields
- \ref tutorial_hydraulics
- \ref tutorial_hydraulics_coupling
- \ref tutorial_hydrodynamics
- \ref tutorial_imu
- \ref tutorial_io
- \ref tutorial_lidar
- \ref tutorial_listeners
- \ref tutorial_machine_reconfiguration
- \ref tutorial_material
- \ref tutorial_mergeSplitHandler
- \ref tutorial_mergedBody
- \ref tutorial_odometer
- \ref tutorial_particleSystem
- \ref tutorial_pidController
- \ref tutorial_pointcloud_over_ros2
- \ref tutorial_python_excavator_controller
- \ref tutorial_rigidBodyEmitter
- \ref tutorial_robot_pick_and_place
- \ref tutorial_ros2
- \ref tutorial_statistics
- \ref tutorial_suctionGripper
- \ref tutorial_terrainPager_tileEvents
- \ref tutorial_threadAffinity
- \ref tutorial_threads
- \ref tutorial_tire
- \ref tutorial_trackedVehicle
- \ref tutorial_tree
- \ref tutorial_trimesh
- \ref tutorial_wind
- \ref tutorial_wire1
- \ref tutorial_wireLink
- \ref tutorial_wireWindAndWater


\section tutorial_agxPlot tutorial_agxPlot.cpp
\include tutorial_agxPlot.cpp
\section tutorial_agxTerrain tutorial_agxTerrain.cpp
\include tutorial_agxTerrain.cpp
\section tutorial_agxTerrain_ClamShellBucket tutorial_agxTerrain_ClamShellBucket.cpp
\include tutorial_agxTerrain_ClamShellBucket.cpp
\section tutorial_ballJoint_secondaryConstraints tutorial_ballJoint_secondaryConstraints.cpp
\include tutorial_ballJoint_secondaryConstraints.cpp
\section tutorial_basicSimulation tutorial_basicSimulation.cpp
\include tutorial_basicSimulation.cpp
\section tutorial_beam tutorial_beam.cpp
\include tutorial_beam.cpp
\section tutorial_bodies tutorial_bodies.cpp
\include tutorial_bodies.cpp
\section tutorial_bulldozer_with_terrain tutorial_bulldozer_with_terrain.cpp
\include tutorial_bulldozer_with_terrain.cpp
\section tutorial_cable tutorial_cable.cpp
\include tutorial_cable.cpp
\section tutorial_cableWindAndWater tutorial_cableWindAndWater.cpp
\include tutorial_cableWindAndWater.cpp
\section tutorial_cable_damage tutorial_cable_damage.cpp
\include tutorial_cable_damage.cpp
\section tutorial_cable_tunneling_guard tutorial_cable_tunneling_guard.cpp
\include tutorial_cable_tunneling_guard.cpp
\section tutorial_car tutorial_car.cpp
\include tutorial_car.cpp
\section tutorial_carSteering tutorial_carSteering.cpp
\include tutorial_carSteering.cpp
\section tutorial_centerOfBuoyancy tutorial_centerOfBuoyancy.cpp
\include tutorial_centerOfBuoyancy.cpp
\section tutorial_collisionDetection tutorial_collisionDetection.cpp
\include tutorial_collisionDetection.cpp
\section tutorial_constraints tutorial_constraints.cpp
\include tutorial_constraints.cpp
\section tutorial_contactForces tutorial_contactForces.cpp
\include tutorial_contactForces.cpp
\section tutorial_contactMeasurement tutorial_contactMeasurement.cpp
\include tutorial_contactMeasurement.cpp
\section tutorial_convex tutorial_convex.cpp
\include tutorial_convex.cpp
\section tutorial_conveyorBelts tutorial_conveyorBelts.cpp
\include tutorial_conveyorBelts.cpp
\section tutorial_create_oriented_bounding_volume tutorial_create_oriented_bounding_volume.cpp
\include tutorial_create_oriented_bounding_volume.cpp
\section tutorial_customConstraints tutorial_customConstraints.cpp
\include tutorial_customConstraints.cpp
\section tutorial_customMergeSplitAlgorithm tutorial_customMergeSplitAlgorithm.cpp
\include tutorial_customMergeSplitAlgorithm.cpp
\section tutorial_driveTrain tutorial_driveTrain.cpp
\include tutorial_driveTrain.cpp
\section tutorial_driveTrain_ElectricMotor tutorial_driveTrain_ElectricMotor.cpp
\include tutorial_driveTrain_ElectricMotor.cpp
\section tutorial_driveTrain_combustionEngine tutorial_driveTrain_combustionEngine.cpp
\include tutorial_driveTrain_combustionEngine.cpp
\section tutorial_encoder tutorial_encoder.cpp
\include tutorial_encoder.cpp
\section tutorial_energyManager tutorial_energyManager.cpp
\include tutorial_energyManager.cpp
\section tutorial_fracture tutorial_fracture.cpp
\include tutorial_fracture.cpp
\section tutorial_frictionModels tutorial_frictionModels.cpp
\include tutorial_frictionModels.cpp
\section tutorial_gamePad tutorial_gamePad.cpp
\include tutorial_gamePad.cpp
\section tutorial_granularBodies tutorial_granularBodies.cpp
\include tutorial_granularBodies.cpp
\section tutorial_gravityFields tutorial_gravityFields.cpp
\include tutorial_gravityFields.cpp
\section tutorial_hydraulics tutorial_hydraulics.cpp
\include tutorial_hydraulics.cpp
\section tutorial_hydraulics_coupling tutorial_hydraulics_coupling.cpp
\include tutorial_hydraulics_coupling.cpp
\section tutorial_hydrodynamics tutorial_hydrodynamics.cpp
\include tutorial_hydrodynamics.cpp
\section tutorial_imu tutorial_imu.cpp
\include tutorial_imu.cpp
\section tutorial_io tutorial_io.cpp
\include tutorial_io.cpp
\section tutorial_lidar tutorial_lidar.cpp
\include tutorial_lidar.cpp
\section tutorial_listeners tutorial_listeners.cpp
\include tutorial_listeners.cpp
\section tutorial_machine_reconfiguration tutorial_machine_reconfiguration.cpp
\include tutorial_machine_reconfiguration.cpp
\section tutorial_material tutorial_material.cpp
\include tutorial_material.cpp
\section tutorial_mergeSplitHandler tutorial_mergeSplitHandler.cpp
\include tutorial_mergeSplitHandler.cpp
\section tutorial_mergedBody tutorial_mergedBody.cpp
\include tutorial_mergedBody.cpp
\section tutorial_odometer tutorial_odometer.cpp
\include tutorial_odometer.cpp
\section tutorial_particleSystem tutorial_particleSystem.cpp
\include tutorial_particleSystem.cpp
\section tutorial_pidController tutorial_pidController.cpp
\include tutorial_pidController.cpp
\section tutorial_pointcloud_over_ros2 tutorial_pointcloud_over_ros2.cpp
\include tutorial_pointcloud_over_ros2.cpp
\section tutorial_python_excavator_controller tutorial_python_excavator_controller.cpp
\include tutorial_python_excavator_controller.cpp
\section tutorial_rigidBodyEmitter tutorial_rigidBodyEmitter.cpp
\include tutorial_rigidBodyEmitter.cpp
\section tutorial_robot_pick_and_place tutorial_robot_pick_and_place.cpp
\include tutorial_robot_pick_and_place.cpp
\section tutorial_ros2 tutorial_ros2.cpp
\include tutorial_ros2.cpp
\section tutorial_statistics tutorial_statistics.cpp
\include tutorial_statistics.cpp
\section tutorial_suctionGripper tutorial_suctionGripper.cpp
\include tutorial_suctionGripper.cpp
\section tutorial_terrainPager_tileEvents tutorial_terrainPager_tileEvents.cpp
\include tutorial_terrainPager_tileEvents.cpp
\section tutorial_threadAffinity tutorial_threadAffinity.cpp
\include tutorial_threadAffinity.cpp
\section tutorial_threads tutorial_threads.cpp
\include tutorial_threads.cpp
\section tutorial_tire tutorial_tire.cpp
\include tutorial_tire.cpp
\section tutorial_trackedVehicle tutorial_trackedVehicle.cpp
\include tutorial_trackedVehicle.cpp
\section tutorial_tree tutorial_tree.cpp
\include tutorial_tree.cpp
\section tutorial_trimesh tutorial_trimesh.cpp
\include tutorial_trimesh.cpp
\section tutorial_wind tutorial_wind.cpp
\include tutorial_wind.cpp
\section tutorial_wire1 tutorial_wire1.cpp
\include tutorial_wire1.cpp
\section tutorial_wireLink tutorial_wireLink.cpp
\include tutorial_wireLink.cpp
\section tutorial_wireWindAndWater tutorial_wireWindAndWater.cpp
\include tutorial_wireWindAndWater.cpp

*/
