/*
Copyright 2007-2026. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/

#pragma once

#include <cstdint>

#include <agx/agxCore_export.h>

namespace agx {

  /// RAII guard: enables FTZ/DAZ (SSE) or FZ (AArch64 FPCR) in ctor, restores prior state in dtor.
  class AGXCORE_EXPORT DenormalizationGuard
  {
  public:
    #if defined(__aarch64__)
    using RegDataType = std::uint64_t;
    #else
    using RegDataType = std::uint32_t;
    #endif

    DenormalizationGuard();

    ~DenormalizationGuard();

    DenormalizationGuard(const DenormalizationGuard&) = delete;
    DenormalizationGuard& operator=(const DenormalizationGuard&) = delete;

    DenormalizationGuard(DenormalizationGuard&&) = delete;
    DenormalizationGuard& operator=(DenormalizationGuard&&) = delete;

    /**
    Enable handling which turns subnormal floating point numbers into zero.
    \return Old value from control register, can/should be used together with disable.
    */
    static RegDataType enable();

    /**
    Disables handling of subnormal floating point numbers if given the return value from enable()
    */
    static void disable(RegDataType value);

  private:
    RegDataType m_savedRegisterState;
  };

} // namespace agx
