%module(package="openplx") Sensors
%feature("autodoc", "3");
%include <exception.i>
%include <std_string.i>
%include <python/openplx/openplx_shared_ptr.i>
%include <std_vector.i>
%import(module="Core") <python/openplx/Core.i>
%import(module="DriveTrain") <python/DriveTrain/DriveTrainModule.i>
%import(module="Math") <python/Math/MathModule.i>
%import(module="Physics") <python/Physics/PhysicsModule.i>
%import(module="Physics1D") <python/Physics1D/Physics1DModule.i>
%import(module="Physics3D") <python/Physics3D/Physics3DModule.i>
%{
#include <openplx/Token.h>
using namespace openplx;
#include <openplx/NodeType.h>
#include <openplx/Node.h>
#include <openplx/Any.h>
#include <openplx/Object.h>
#include <openplx/EvaluatorContext.h>
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%include <exception.i>
%include <std_string.i>
%include <std_vector.i>
%apply unsigned long long int { uint64_t }
%apply long long int { int64_t }

%include <python/Sensors/Sensors.i>
OPENPLX_SWIG_BUNDLE_RENAMES_Sensors(Sensors_);
OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Sensors();
OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Sensors();
OPENPLX_SWIG_BUNDLE_VECTORS_Sensors();
%include "openplx/Sensors/ForceTorqueSensor.h"
