%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Sensors()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Sensors()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Sensors(prefix)
%rename(prefix ## ForceTorqueSensor) openplx::Sensors::ForceTorqueSensor;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors()
%shared_ptr(openplx::Sensors::ForceTorqueSensor);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors()
%typemap(out) std::shared_ptr<openplx::Sensors::ForceTorqueSensor> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Sensors()
%template(Sensors_ForceTorqueSensor_Vector) std::vector<std::shared_ptr<openplx::Sensors::ForceTorqueSensor>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Sensors::ForceTorqueSensor>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Sensors::ForceTorqueSensor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::ForceTorqueSensor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Sensors::ForceTorqueSensor>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Sensors::ForceTorqueSensor>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Sensors::ForceTorqueSensor>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Sensors()
%include "openplx/Sensors/ForceTorqueSensor.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Sensors()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Sensors()
%{
#include <openplx/DriveTrain/DriveTrain_all.h>
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Physics1D/Physics1D_all.h>
#include <openplx/Physics3D/Physics3D_all.h>
#include <openplx/Sensors/Sensors_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Sensors()
%import "Sensors.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Sensors()
%include <python/DriveTrain/DriveTrain.i>
OPENPLX_SWIG_BUNDLE_IMPORT_DriveTrain();
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%include <python/Physics1D/Physics1D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics1D();
%include <python/Physics3D/Physics3D.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics3D();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Sensors()
%import "DriveTrain.i"
%import "Math.i"
%import "Physics.i"
%import "Physics1D.i"
%import "Physics3D.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Sensors(prefix)
OPENPLX_SWIG_NS_RENAMES_Sensors(prefix);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Sensors()
OPENPLX_SWIG_NS_SHARED_POINTERS_Sensors();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Sensors()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Sensors();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Sensors()
OPENPLX_SWIG_NS_VECTORS_Sensors();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Sensors()
OPENPLX_SWIG_NS_INCLUDES_Sensors();
%enddef

