#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Visuals/Geometries/TriMeshGeometry.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model ExternalTriMeshGeometry */
namespace openplx::Visuals::Geometries {
    /**
     * A contact geometry consisting of a triangle mesh stored in an external file at path
     **/
    class ExternalTriMeshGeometry : public openplx::Visuals::Geometries::TriMeshGeometry {
        protected:
            std::string m_path;
            std::shared_ptr<openplx::Math::Vec3> m_scale;

        public:
            ExternalTriMeshGeometry();
            std::string path() const;
            std::shared_ptr<openplx::Math::Vec3> scale() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
