
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>

namespace openplx
{
    class VarDeclaration : public Node, public std::enable_shared_from_this<VarDeclaration>
    {
        public:
            /* Factories */
            static VarDeclPtr create(
                const Token& name_token,
                const Token& type_modifier,
                const Token& type_qualifier,
                const std::vector<Token>& type_segments,
                ExprPtr value);

            /* Overrides */
            VarDeclPtr asVarDeclaration() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;

            /* Name */
            const Token& getNameToken() const;
            const std::string& getName() const;
            void setName(const std::string &name);

            /* Type modifier (is or becomes) */
            Token getTypeModifier() const;

            /* Type qualifier (external or none) */
            Token getTypeQualifier() const;
            bool isExternal() const;

            /* Type */
            std::string typeSegmentsAsString() const;
            const std::vector<Token>& getTypeSegments() const;
            TypePtr getType() const;
            void setType(TypePtr type);

            /* Previous type (only for becomes) */
            TypePtr getPreviousType() const;
            void setPreviousType(TypePtr type);

            /* Value */
            ExprPtr getValue() const;
            void setValue(ExprPtr value);

            /* Owning model */
            ModelDeclPtr getOwningModel() const;
            void setOwningModel(ModelDeclPtr owning_model);

            /* Owning document */
            DocPtr getOwningDocument() const;
            void setOwningDocument(DocPtr owning_document);

        private:
            VarDeclaration();
            Token m_name_token;
            Token m_type_modifier;
            Token m_type_qualifier;
            std::vector<Token> m_type_segments;
            ExprPtr m_value;
            TypePtr m_type;
            TypePtr m_previous_type;
            ModelDeclPtr m_owning_model;
            DocPtr m_owning_document;
    };
}
