
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    /**
     * Represents an expression of the form: -3
     * - is the operator
     * 3 is the operand
     */
    class Unary : public Expression, public std::enable_shared_from_this<Unary>
    {
        public:
            /* Factories */
            static UnaryPtr create(const Token& operator_token, ExprPtr operand);

            /* Overrides */
            UnaryPtr asUnary() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;

            /* Operator */
            Token getOperatorToken() const;
            std::string getOpStr() const;

            /* Operand */
            ExprPtr getOperand() const;
            void setOperand(ExprPtr operand);

            /* Overloaded operator */
            OpOverloadPtr getOverloadedOperator() const;
            void setOverloadedOperator(OpOverloadPtr op_overload);

        private:
            Unary();
            Token m_operator_token;
            ExprPtr m_operand;
            OpOverloadPtr m_op_overload;
    };
}
