#pragma once

// We want REQUIRE_ERROR as macro to have clion point at the correct test
#ifdef __clang__
#define DO_PRAGMA(x) _Pragma(#x)
#define REQUIRE_ERROR(error, error_code, line, col)                          \
    DO_PRAGMA(clang diagnostic push)                                         \
    DO_PRAGMA(clang diagnostic ignored "-Wpotentially-evaluated-expression") \
    do {                                                                     \
        REQUIRE((error)->getErrorCode() == (error_code));                    \
        REQUIRE((error)->getLine() == (line));                               \
        REQUIRE((error)->getColumn() == (col));                              \
    } while (0)                                                              \
    DO_PRAGMA(clang diagnostic pop)
#define REQUIRE_ERROR_STRP(error, error_code, line, col, param)              \
    DO_PRAGMA(clang diagnostic push)                                         \
    DO_PRAGMA(clang diagnostic ignored "-Wpotentially-evaluated-expression") \
    do {                                                                     \
        REQUIRE((error)->getErrorCode() == (error_code));                    \
        REQUIRE((error)->getLine() == (line));                               \
        REQUIRE((error)->getColumn() == (col));                              \
        auto str_error = Error::as<StringParameterError>(error);             \
        REQUIRE(str_error != nullptr);                                       \
        REQUIRE(str_error->getStringParameter() == (param));                 \
    } while (0);                                                             \
    DO_PRAGMA(clang diagnostic pop)
#else
#define REQUIRE_ERROR(error, error_code, line, col)              \
    do {                                                         \
        REQUIRE((error)->getErrorCode() == (error_code));        \
        REQUIRE((error)->getLine() == (line));                   \
        REQUIRE((error)->getColumn() == (col));                  \
    } while (0);
#define REQUIRE_ERROR_STRP(error, error_code, line, col, param)  \
    do {                                                         \
        REQUIRE((error)->getErrorCode() == (error_code));        \
        REQUIRE((error)->getLine() == (line));                   \
        REQUIRE((error)->getColumn() == (col));                  \
        auto str_error = Error::as<StringParameterError>(error); \
        REQUIRE(str_error != nullptr);                           \
        REQUIRE(str_error->getStringParameter() == (param));     \
    } while (0);
#endif
