#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/GravitationalField.h>
#include <openplx/Math/Vec3.h>
/* Generated code for model UniformGravitationalField */
namespace openplx::Simulation {
    /**
     *     UniformGravitationalField calculates a gravity which is uniform in magnitude and direction
     *     over the entire environment, directed along a specified vector.
     *     vector - specifies the direction and magnitude of the gravity
     *     */
    class UniformGravitationalField : public openplx::Simulation::GravitationalField {
        protected:
            std::shared_ptr<openplx::Math::Vec3> m_vector;

        public:
            UniformGravitationalField();
            std::shared_ptr<openplx::Math::Vec3> vector() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
