#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics3D/System.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Physics3D/Charges/RedirectedMateConnector.h>
#include <openplx/Physics3D/Interactions/Lock.h>
/* Generated code for model ForceTorqueSensor */
namespace openplx::Sensors {
    /**
     * A sensor for measuring force and torque between two rigid bodies.
     * Internally the sensor will lock two bodies with a Physics3D.Interactions.Lock.
     * It is assumed that an external mate has assembled the input and output bodies,
     * in the wanted configuration.
     * The internal_lock will be setup at rest at the center of the force torque system.
     **/
    class ForceTorqueSensor : public openplx::Physics3D::System {
        protected:
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_input_body;
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> m_output_body;
            std::shared_ptr<openplx::Physics3D::Charges::RedirectedMateConnector> m_input_connector;
            std::shared_ptr<openplx::Physics3D::Charges::RedirectedMateConnector> m_output_connector;
            std::shared_ptr<openplx::Physics3D::Interactions::Lock> m_internal_lock;

        public:
            ForceTorqueSensor();
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> input_body() const;
            std::shared_ptr<openplx::Physics3D::Bodies::RigidBody> output_body() const;
            std::shared_ptr<openplx::Physics3D::Charges::RedirectedMateConnector> input_connector() const;
            std::shared_ptr<openplx::Physics3D::Charges::RedirectedMateConnector> output_connector() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Lock> internal_lock() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
