#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
/* Generated code for model SensorValues */
namespace openplx::Robotics::Signals {
    class SensorValues : public openplx::Core::Object {
        protected:
            std::string m_name;
            std::vector<std::shared_ptr<openplx::Physics::Signals::Value>> m_values;

        public:
            SensorValues();
            std::string name() const;
            std::vector<std::shared_ptr<openplx::Physics::Signals::Value>> values() const;
            static std::shared_ptr<openplx::Robotics::Signals::SensorValues> create(std::string name, std::vector<std::shared_ptr<openplx::Physics::Signals::Value>> values);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
