
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>
#include <openplx/Type.h>
#include <openplx/Expression.h>

namespace openplx
{
    enum class PrimitiveTypeType
    {
        Real,
        Int,
        Bool,
        String
    };

    class PrimitiveType : public Type, public std::enable_shared_from_this<PrimitiveType>
    {
        public:
            /* Factories */
            static PrimitiveTypePtr create(PrimitiveTypeType type_type);

            /* Overrides */
            PrimitiveTypePtr asPrimitiveType() override;
            TypePtr asType() override;
            void accept(NodeVisitor& visitor) override;
            std::string toString() override;
            std::string toKey() override;
            bool isAssignableTo(const TypePtr &other) override;

            /* Type */
            PrimitiveTypeType getTypeType() const;

        private:
            PrimitiveType(PrimitiveTypeType type_type);
            PrimitiveTypeType m_type_type;
    };
}
