#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Input.h>
#include <openplx/Physics3D/Signals/Torque3DInputTrait.h>
/* Generated code for model Torque3DInput */
namespace openplx::Physics3D::Signals {
    /**
     * A 3D Torque input given an interaction.
     * For interactions where it is unambiguous which torque is considered,
     * the input will update that value.
     **/
    class Torque3DInput : public openplx::Physics::Signals::Input {
        protected:
            std::weak_ptr<openplx::Physics3D::Signals::Torque3DInputTrait> m_source;

        public:
            Torque3DInput();
            std::shared_ptr<openplx::Physics3D::Signals::Torque3DInputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
