#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Signals/LinearVelocity3DOutput.h>
#include <openplx/Physics3D/Signals/MateConnector/MateConnectorOutputTrait.h>
#include <openplx/Physics3D/Signals/MateConnector/MCLinearVelocity3DOutputTrait.h>
/* Generated code for model LinearVelocity3DOutput */
namespace openplx::Physics3D::Signals::MateConnector {
    /**
     * Emits a ValueOutputSignal where the signal value is the directional velocity of the source
     * relative_to      - You may specify a MateConnector as the relative_to parameter to get the value relative to that mate connector
     **/
    class LinearVelocity3DOutput : public openplx::Physics3D::Signals::LinearVelocity3DOutput, public openplx::Physics3D::Signals::MateConnector::MateConnectorOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics3D::Charges::MateConnector> m_relative_to;

        public:
            LinearVelocity3DOutput();
            std::shared_ptr<openplx::Physics3D::Charges::MateConnector> relative_to() const override;
            std::shared_ptr<openplx::Physics3D::Signals::MateConnector::MCLinearVelocity3DOutputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
