#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Signals/AngularVelocity3DOutput.h>
#include <openplx/Physics3D/Signals/MateConnector/MateConnectorOutputTrait.h>
#include <openplx/Physics3D/Signals/MateConnector/MCAngularVelocity3DOutputTrait.h>
/* Generated code for model AngularVelocity3DOutput */
namespace openplx::Physics3D::Signals::MateConnector {
    /**
     * Emits a ValueOutputSignal where the signal value is the directional angular velocity of the source
     * relative_to      - You may specify a MateConnector as the relative_to parameter to get the value relative to that mate connector
     **/
    class AngularVelocity3DOutput : public openplx::Physics3D::Signals::AngularVelocity3DOutput, public openplx::Physics3D::Signals::MateConnector::MateConnectorOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics3D::Charges::MateConnector> m_relative_to;

        public:
            AngularVelocity3DOutput();
            std::shared_ptr<openplx::Physics3D::Charges::MateConnector> relative_to() const override;
            std::shared_ptr<openplx::Physics3D::Signals::MateConnector::MCAngularVelocity3DOutputTrait> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
