#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/Mate.h>
#include <openplx/Physics/Signals/Force3DOutputTrait.h>
#include <openplx/Physics/Signals/Torque3DOutputTrait.h>
#include <openplx/Physics3D/Interactions/Dissipation/DefaultLockDissipation.h>
#include <openplx/Physics3D/Interactions/Flexibility/DefaultLockFlexibility.h>
#include <openplx/Physics3D/Interactions/Toughness/DefaultLockToughness.h>
#include <openplx/Physics/Signals/Torque3DOutput.h>
#include <openplx/Physics/Signals/Force3DOutput.h>
/* Generated code for model Lock */
namespace openplx::Physics3D::Interactions {
    /**
     * Interaction that constrain all 6 degrees of freedom between two bodies, or one body and the world.
     * The force and torque output vectors are reported in the world frame.
     *     */
    class Lock : public openplx::Physics3D::Interactions::Mate, public openplx::Physics::Signals::Force3DOutputTrait, public openplx::Physics::Signals::Torque3DOutputTrait {
        protected:
            std::shared_ptr<openplx::Physics::Signals::Torque3DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::Force3DOutput> m_force_output;

        public:
            Lock();
            std::shared_ptr<openplx::Physics3D::Interactions::Dissipation::DefaultLockDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Flexibility::DefaultLockFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Toughness::DefaultLockToughness> toughness() const;
            std::shared_ptr<openplx::Physics::Signals::Torque3DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::Force3DOutput> force_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
