#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Charges/RedirectedMateConnector.h>
/* Generated code for model StructuralPlanarConnector */
namespace openplx::Physics3D::Charges {
    /**
     *     The StructuralPlanarConnector is a RedirectedMateConnector for modeling in a plane.
     *     It can be used in combination with the StructuralPlane to conveniently  model
     *     planar mechanical structures like crane arms or tracked system.
     *     The main_axis is always considered pointing in the normal direcion of the StructuralPlane, which is Z.
     *     The default normal direction is X, and the specified angle will rotate the normal direction around the main_axis.
     *     */
    class StructuralPlanarConnector : public openplx::Physics3D::Charges::RedirectedMateConnector {
        protected:
            double m_angle;
            double m_x;
            double m_y;

        public:
            StructuralPlanarConnector();
            double angle() const;
            double x() const;
            double y() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
