#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Bodies/Kinematics.h>
#include <openplx/Math/AffineTransform.h>
/* Generated code for model Kinematics */
namespace openplx::Physics3D::Bodies {
    /**
     * Initial state of a 3D Body
     **/
    class Kinematics : public openplx::Physics::Bodies::Kinematics {
        protected:
            std::shared_ptr<openplx::Math::AffineTransform> m_local_transform;

        public:
            Kinematics();
            std::shared_ptr<openplx::Math::AffineTransform> local_transform() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
