#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Signals/OutputSignal.h>
#include <openplx/Physics/Signals/Value.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Math/Vec3.h>
#include <openplx/Math/Vec2.h>
/* Generated code for model ValueOutputSignal */
namespace openplx::Physics::Signals {
    class ValueOutputSignal : public openplx::Physics::Signals::OutputSignal {
        protected:
            std::shared_ptr<openplx::Physics::Signals::Value> m_value;

        public:
            ValueOutputSignal();
            std::shared_ptr<openplx::Physics::Signals::Value> value() const;
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> create(std::shared_ptr<openplx::Physics::Signals::Value> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_angle(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_angular_velocity_1d(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_distance(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_force_1d(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_velocity_1d(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_torque_1d(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_acceleration_3d(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_angular_acceleration_3d(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_angular_velocity_3d(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_force_3d(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_torque_3d(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_velocity_3d(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_position_3d(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_rpy(std::shared_ptr<openplx::Math::Vec3> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_int(int64_t v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_bool(bool v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_fraction(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_duration(double v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_torque_range(std::shared_ptr<openplx::Math::Vec2> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            static std::shared_ptr<openplx::Physics::Signals::ValueOutputSignal> from_force_range(std::shared_ptr<openplx::Math::Vec2> v, std::shared_ptr<openplx::Physics::Signals::Output> source);
            bool is_real() const;
            bool is_vec3() const;
            bool is_vec2() const;
            bool is_int() const;
            bool is_bool() const;
            double as_real() const;
            std::shared_ptr<openplx::Math::Vec3> as_vec3() const;
            double as_angle() const;
            double as_angular_velocity_1d() const;
            double as_distance() const;
            double as_force_1d() const;
            double as_velocity_1d() const;
            double as_torque_1d() const;
            std::shared_ptr<openplx::Math::Vec3> as_acceleration_3d() const;
            std::shared_ptr<openplx::Math::Vec3> as_angular_acceleration_3d() const;
            std::shared_ptr<openplx::Math::Vec3> as_angular_velocity_3d() const;
            std::shared_ptr<openplx::Math::Vec3> as_force_3d() const;
            std::shared_ptr<openplx::Math::Vec3> as_torque_3d() const;
            std::shared_ptr<openplx::Math::Vec3> as_velocity_3d() const;
            std::shared_ptr<openplx::Math::Vec3> as_position_3d() const;
            std::shared_ptr<openplx::Math::Vec3> as_rpy() const;
            int64_t as_int() const;
            bool as_bool() const;
            double as_fraction() const;
            double as_duration() const;
            std::shared_ptr<openplx::Math::Vec2> as_vec2() const;
            std::shared_ptr<openplx::Math::Vec2> as_torque_range() const;
            std::shared_ptr<openplx::Math::Vec2> as_force_range() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
