
#pragma once

#include <openplx/Node.h>

namespace openplx {
    class PathNode {
        public:
            static size_t createInto(NodePtr node, std::vector<PathNode>& target);
            static size_t appendLastSegment(VarAssignPtr var_assignment, std::vector<PathNode>& target);

            PathNode(PathNode&& node) noexcept;
            PathNode(const PathNode& node) noexcept;
            PathNode& operator=(const PathNode& node);

            bool isSymbol() const;
            bool isModel() const;
            bool isConstModel() const;
            bool isValid() const;

            std::string toString() const;

            const NodePtr& getNode() const;

            ExprPtr getValue() const;
            DocPtr getOwningDocument() const;
            std::string getSourceId() const;
            std::string getSymbol() const;
            Token getNameToken() const;
            TypePtr getType() const;
            void setOuterType(TypePtr outer_type);
            TypePtr getOuterType() const;

            bool operator!=(const PathNode& other) const;
            bool operator==(const PathNode& other) const;

            void unbind();

        private:
            PathNode() = delete;
            PathNode(NodePtr node, std::string symbol, size_t index);
            NodePtr m_node;
            TypePtr m_outer_type;
            std::string m_symbol;
            size_t m_index;
    };
}
