
#pragma once

#include <memory>

namespace openplx
{
    enum class NodeType {
        Document,
        ModelDeclaration,
        VarDeclaration,
        VarAssignment,
        BinaryOp,
        MethodDeclaration,
        Parameter,
        Array,
        ArrayType,
        Constant,
        Call,
        MemberAccess,
        PrimitiveType,
        Unary,
        Indexing,
        OperatorOverload,
        Annotation,
        Import,
        TraitImpl,
        Initializer,
        InitializerType,
        Deletion,
        WithType,
        SymbolMetaData
    };

    class Node;
    class Document;
    class ModelDeclaration;
    class VarDeclaration;
    class VarAssignment;
    class Parameter;
    class Expression;
    class Constant;
    class MethodDeclaration;
    class BinaryOp;
    class Array;
    class ArrayType;
    class Unary;
    class MemberAccess;
    class Call;
    class PrimitiveType;
    class Type;
    class CompositeType;
    class WithType;
    class Indexing;
    class OperatorOverload;
    class Annotation;
    class SortedAssignment;
    class Import;
    class TraitImpl;
    class Initializer;
    class InitializerType;
    class Deletion;
    class SymbolMetaData;

    using NodePtr = std::shared_ptr<Node>;
    using DocPtr = std::shared_ptr<Document>;
    using ModelDeclPtr = std::shared_ptr<ModelDeclaration>;
    using VarDeclPtr = std::shared_ptr<VarDeclaration>;
    using VarAssignPtr = std::shared_ptr<VarAssignment>;
    using ExprPtr = std::shared_ptr<Expression>;
    using ConstantPtr = std::shared_ptr<Constant>;
    using ParamPtr = std::shared_ptr<Parameter>;
    using MethodDeclPtr = std::shared_ptr<MethodDeclaration>;
    using BinaryOpPtr = std::shared_ptr<BinaryOp>;
    using ArrayPtr = std::shared_ptr<Array>;
    using ArrayTypePtr = std::shared_ptr<ArrayType>;
    using UnaryPtr = std::shared_ptr<Unary>;
    using MemberAccessPtr = std::shared_ptr<MemberAccess>;
    using CallPtr = std::shared_ptr<Call>;
    using PrimitiveTypePtr = std::shared_ptr<PrimitiveType>;
    using TypePtr = std::shared_ptr<Type>;
    using CompositeTypePtr = std::shared_ptr<CompositeType>;
    using WithTypePtr = std::shared_ptr<WithType>;
    using IndexingPtr = std::shared_ptr<Indexing>;
    using OpOverloadPtr = std::shared_ptr<OperatorOverload>;
    using AnnotationPtr = std::shared_ptr<Annotation>;
    using SortedAssignmentPtr = std::shared_ptr<SortedAssignment>;
    using ImportPtr = std::shared_ptr<Import>;
    using TraitImplPtr = std::shared_ptr<TraitImpl>;
    using InitializerPtr = std::shared_ptr<Initializer>;
    using InitializerTypePtr = std::shared_ptr<InitializerType>;
    using DeletionPtr = std::shared_ptr<Deletion>;
    using SymbolMetaDataPtr = std::shared_ptr<SymbolMetaData>;
}
