#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Math/MathForward.h>
/* Generated code for model Functions */
namespace openplx::Math {
    class Functions : public openplx::Core::Object {
        protected:

        public:
            Functions();
            static double sin(double x);
            static double cos(double x);
            static double tan(double x);
            static double arcsin(double x);
            static double arccos(double x);
            static double arctan(double x);
            static double arctan2(double x, double y);
            static double sqrt(double values);
            static double pow(double base, double exponent);
            static double mean(std::vector<double> values);
            static double median(std::vector<double> values);
            static double harmonic_mean(std::vector<double> values);
            static double min(std::vector<double> values);
            static double max(std::vector<double> values);
            static double sum(std::vector<double> values);
            static bool equals_approx(double value, double ref);
            static double inf();
            static double neg_inf();
            static double rad_to_deg(double rad);
            static double deg_to_rad(double deg);
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
