
#pragma once

#include <memory>
#include <openplx/Node.h>
#include <openplx/Expression.h>

namespace openplx
{
    class Indexing : public Expression, public std::enable_shared_from_this<Indexing>
    {
        public:
            /* Factories */
            static IndexingPtr create(ExprPtr receiver, ExprPtr index);

            /* Overrides */
            IndexingPtr asIndexing() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;
            ExprPtr clone() override;

            /* Receiver */
            ExprPtr getReceiver();

            /* Index */
            ExprPtr getIndex();

        private:
            Indexing(ExprPtr&& receiver, ExprPtr&& index);
            ExprPtr m_receiver;
            ExprPtr m_index;
    };
}
