#pragma once

#include <string>
#include <openplx/Error.h>

namespace openplx {

    class ErrorFormatter: public ErrorVisitor {
        public:
            ErrorFormatter(bool decorate = true);
            virtual std::string format(Error& error);

            // Below are intended to be called by Error:s only
            virtual std::string visitError(const Error& error) override;
            virtual std::string visitCycleFoundError(const CycleFoundError& error) override;
            virtual std::string visitStringParameterError(const StringParameterError& error) override;
        protected:
            /**
             * @brief Override this method to create your own output format
             *
             * @param message the message explaining the error_code
             * @param error
             * @return std::string the string you want to output
             */
            virtual std::string formatMessage(const std::string& message, const openplx::Error &error);

            bool m_decorate;
    };
}
