#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/Actuator.h>
#include <openplx/Physics3D/Interactions/Prismatic.h>
/* Generated code for model PrismaticActuator */
namespace openplx::DriveTrain {
    /**
     *     Actuation of the linear degree of freedom of the 3D Prismatic
     *     by rotaional to translational conversion from a 1D rotational shaft.
     *     */
    class PrismaticActuator : public openplx::DriveTrain::Actuator {
        protected:

        public:
            PrismaticActuator();
            std::shared_ptr<openplx::Physics3D::Interactions::Prismatic> mate_3d() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
