#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics1D/Interactions/Mate.h>
#include <openplx/Physics/Signals/Torque1DOutputTrait.h>
#include <openplx/Physics/Signals/IntInputTrait.h>
#include <openplx/Physics/Signals/IntOutputTrait.h>
#include <openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>
#include <openplx/Physics/Signals/Torque1DOutput.h>
#include <openplx/Physics/Signals/IntInput.h>
#include <openplx/Physics/Signals/IntOutput.h>
/* Generated code for model GearBox */
namespace openplx::DriveTrain {
    /**
     *     The GearBox is a rotational coupling between two RotationalBodies.
     *     It has two defined lists of gears, one for forward and one for reverse gears.
     *     It always has one neutral gear, which is selected with zero as initial_gear or input signal.
     *     The forward and reverse gear lists could include additional neutral gears,
     *     but it is not recommended.
     *     Only the absolute value of the gear ratios will be considered, the sign is defined by the list membership.
     *     The current gear defines a relationship between the rotational speeds of the bodies using a specified gear ratio.
     *     A positive initial_gear or input signal will select a gear from the forward_gear list.
     *     A negative initial_gear or input signal will select a gear from the reverse_gear list.
     *     Zero initial_gear or input signal will put the gear in neutral.
     *     The model supports flexibility and energy dissipation features.
     *     */
    class GearBox : public openplx::Physics1D::Interactions::Mate, public openplx::Physics::Signals::Torque1DOutputTrait, public openplx::Physics::Signals::IntInputTrait, public openplx::Physics::Signals::IntOutputTrait {
        protected:
            std::vector<double> m_forward_gears;
            std::vector<double> m_reverse_gears;
            int64_t m_initial_gear;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_dissipation;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> m_torque_output;
            std::shared_ptr<openplx::Physics::Signals::IntInput> m_gear_selection_input;
            std::shared_ptr<openplx::Physics::Signals::IntOutput> m_gear_selection_output;

        public:
            GearBox();
            std::vector<double> forward_gears() const;
            std::vector<double> reverse_gears() const;
            int64_t initial_gear() const;
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> dissipation() const;
            std::shared_ptr<openplx::Physics::Signals::Torque1DOutput> torque_output() const;
            std::shared_ptr<openplx::Physics::Signals::IntInput> gear_selection_input() const;
            std::shared_ptr<openplx::Physics::Signals::IntOutput> gear_selection_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}
