
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>

namespace openplx
{
    class Annotation : public Node, public std::enable_shared_from_this<Annotation>
    {
        public:
            /* Factories */
            static AnnotationPtr create(Token identifier, ExprPtr value);

            /* Overrides */
            AnnotationPtr asAnnotation() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;

            /* Identifier */
            Token getIdentifier() const;

            /* Value */
            ExprPtr getValue() const;

            /* Owning document */
            DocPtr getOwningDocument() const;
            void setOwningDocument(DocPtr owning_document);

            /* Owning model */
            ModelDeclPtr getOwningModel() const;
            void setOwningModel(ModelDeclPtr owning_model);

            /* Owning declaration */
            VarAssignPtr getOwningDeclaration() const;
            void setOwningDeclaration(VarAssignPtr owning_declaration);

            /* Source id */
            std::string getSourceIdOrDefault() const;

            /* Utility */
            bool isTrue() const;
            bool isFalse() const;
            bool isString() const;
            bool isString(const std::string& value) const;
            bool isNumber() const;
            bool isStringCaseInsensitive(const std::string& value) const;
            double asReal() const;
            int64_t asInt() const;
            std::string asString() const;
            std::string valueToString() const;

            /* Cloneable */
            AnnotationPtr clone() const;

        private:
            Annotation();
            Token m_identifier;
            ExprPtr m_value;
            DocPtr m_owning_document;
            ModelDeclPtr m_owning_model;
            VarAssignPtr m_owning_declaration;
    };
}
