/*
Copyright 2007-2025. Algoryx Simulation AB.

All AGX source code, intellectual property, documentation, sample code,
tutorials, scene files and technical white papers, are copyrighted, proprietary
and confidential material of Algoryx Simulation AB. You may not download, read,
store, distribute, publish, copy or otherwise disseminate, use or expose this
material unless having a written signed agreement with Algoryx Simulation AB, or having been
advised so by Algoryx Simulation AB for a time limited evaluation, or having purchased a
valid commercial license from Algoryx Simulation AB.

Algoryx Simulation AB disclaims all responsibilities for loss or damage caused
from using this software, unless otherwise stated in written agreements with
Algoryx Simulation AB.
*/
#pragma once
#include <agxSensor/RaytraceSystemNode.h>

namespace agxSensor
{
  /**
  This node doesn't have a representation in the raytrace graph but
  manages adding and removal of children when this nodes parent is
  varying/optional.
  */
  class AGXSENSOR_EXPORT RtNodeGroupHandler : public RtSystemNode
  {
    public:
      DOXYGEN_START_INTERNAL_BLOCK()

      RtNodeGroupHandler() = default;

      RtNode* getParentNode();

    public:
      virtual ~RtNodeGroupHandler() = default;

      virtual RtNode* createNode() override;

      virtual void onChildAdded( SystemNode& child ) override;
      virtual void onParentConnect( RtSystemNode& parent ) override;

      virtual void onChildRemoved( SystemNode& child ) override;
      virtual void onParentDisconnect( RtSystemNode& parent ) override;

      virtual void cleanup() override;

      AGXSTREAM_DECLARE_SERIALIZABLE( agxSensor::RtNodeGroupHandler );

    private:
      void onChildAdded( RtSystemNode* child, RtNode* parentNode );
      void onChildRemoved( RtSystemNode* child, RtNode* parentNode );

      DOXYGEN_END_INTERNAL_BLOCK()
  };
}
