#pragma once
#include <memory>
#include <tuple>
#include <agxOSG/ExampleApplication.h>
#include <openplx/Simulation/Simulation_all.h>
#include <click/Server.h>
#include <agxOpenPLX/ClickAdapter.h>
#include <agxOpenPLX/SignalQueue.h>
#include <agxOSG/openplx/OsgClickInputListener.h>
#include <agxOpenPLX/ClickOutputListener.h>
#include <agxOpenPLX/OutputSignalListener.h>
#include <agxOSG/openplx/ClickKeyboardEventListener.h>

namespace agxopenplx {
    // private inheritance because we want to hide add_listeners() and manualPreFrame() but still not duplicate code.
    class AGXOSG_EXPORT OsgClickAdapter: private ClickAdapter {
    public:
        void sendResetMessage() override;
        bool willSendResetMessage() override;

        /**
         * @brief create and add click listeners to app once and simulation on every call
         */
        void add_listeners(agxOSG::ExampleApplication *app,
                           agxSDK::Simulation *simulation,
                           const std::string &click_server_addr,
                           const std::shared_ptr<openplx::Core::Object> &openplx_scene,
                           std::shared_ptr<InputSignalQueue> input_queue,
                           std::shared_ptr<OutputSignalQueue> output_queue,
                           OutputSignalListener *output_signal_listener);

        std::shared_ptr<ClickInputListener>
        createClickInputListener(const std::shared_ptr<openplx::Core::Object> &openplx_scene,
                                 std::shared_ptr<InputSignalQueue> input_queue,
                                 double time_step,
                                 bool auto_stepping) override;
    };
}
