%define OPENPLX_SWIG_NS_IMPORT_PARENT_DEPENDENCIES_Control_Virtual()
%enddef

%define OPENPLX_SWIG_NS_MODULE_H_DEPENDENCIES_Control_Virtual()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Control/Control_all.h>
%}
%enddef

%define OPENPLX_SWIG_NS_RENAMES_Control_Virtual(prefix)
%rename(prefix ## AffineTransform1DInput) openplx::Control::Virtual::AffineTransform1DInput;
%rename(prefix ## AffineTransform1DOutput) openplx::Control::Virtual::AffineTransform1DOutput;
%rename(prefix ## BroadcastInput) openplx::Control::Virtual::BroadcastInput;
%rename(prefix ## GroupOutput) openplx::Control::Virtual::GroupOutput;
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTERS_Control_Virtual()
%shared_ptr(openplx::Control::Virtual::AffineTransform1DInput);
%shared_ptr(openplx::Control::Virtual::AffineTransform1DOutput);
%shared_ptr(openplx::Control::Virtual::BroadcastInput);
%shared_ptr(openplx::Control::Virtual::GroupOutput);
%enddef

%define OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Control_Virtual()
%typemap(out) std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Control::Virtual::BroadcastInput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%typemap(out) std::shared_ptr<openplx::Control::Virtual::GroupOutput> {
    OPENPLX_CORE_OBJECT_DOWNCAST
}
%enddef

%define OPENPLX_SWIG_NS_VECTORS_Control_Virtual()
%template(Control_Virtual_AffineTransform1DInput_Vector) std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::AffineTransform1DInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Control_Virtual_AffineTransform1DOutput_Vector) std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::AffineTransform1DOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Control_Virtual_BroadcastInput_Vector) std::vector<std::shared_ptr<openplx::Control::Virtual::BroadcastInput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Control::Virtual::BroadcastInput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Control::Virtual::BroadcastInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::BroadcastInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Control::Virtual::BroadcastInput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Control::Virtual::BroadcastInput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::BroadcastInput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%template(Control_Virtual_GroupOutput_Vector) std::vector<std::shared_ptr<openplx::Control::Virtual::GroupOutput>>;
%typemap(out) const std::vector<std::shared_ptr<openplx::Control::Virtual::GroupOutput>>& {
    $result = PyList_New($1->size());
    for (size_t i = 0; i < $1->size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT((*$1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy((*$1)[i], std::shared_ptr<openplx::Control::Virtual::GroupOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::GroupOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%typemap(out) std::vector<std::shared_ptr<openplx::Control::Virtual::GroupOutput>> {
    $result = PyList_New($1.size());
    for (size_t i = 0; i < $1.size(); ++i) {
        DOWNCAST_OPENPLX_OBJECT(($1)[i]);
        PyObject* item = SWIG_NewPointerObj(%new_copy(($1)[i], std::shared_ptr<openplx::Control::Virtual::GroupOutput>), outtype?outtype:$descriptor(std::shared_ptr<openplx::Control::Virtual::GroupOutput>), SWIG_POINTER_OWN);
        PyList_SetItem($result, i, item);
    }
}
%enddef

%define OPENPLX_SWIG_NS_INCLUDES_Control_Virtual()
%include "openplx/Control/Virtual/AffineTransform1DInput.h"
%include "openplx/Control/Virtual/AffineTransform1DOutput.h"
%include "openplx/Control/Virtual/BroadcastInput.h"
%include "openplx/Control/Virtual/GroupOutput.h"
%enddef

%define OPENPLX_SWIG_NS_PY_IMPORTS_Control_Virtual()
%pythoncode %{
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDE_H_DEPENDENCIES_Control()
%{
#include <openplx/Math/Math_all.h>
#include <openplx/Physics/Physics_all.h>
#include <openplx/Control/Control_all.h>
%}
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_Control()
%import "Control_Virtual.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_DEPENDENCIES_Control()
%include <python/Math/Math.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Math();
%include <python/Physics/Physics.i>
OPENPLX_SWIG_BUNDLE_IMPORT_Physics();
%enddef

%define OPENPLX_SWIG_BUNDLE_IMPORT_FLAT_DEPENDENCIES_Control()
%import "Math.i"
%import "Physics.i"
%enddef

%define OPENPLX_SWIG_BUNDLE_RENAMES_Control(prefix)
OPENPLX_SWIG_NS_RENAMES_Control_Virtual(prefix ## Virtual_);
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTERS_Control()
OPENPLX_SWIG_NS_SHARED_POINTERS_Control_Virtual();
%enddef

%define OPENPLX_SWIG_BUNDLE_SHARED_POINTER_DOWNCASTS_Control()
OPENPLX_SWIG_NS_SHARED_POINTER_DOWNCASTS_Control_Virtual();
%enddef

%define OPENPLX_SWIG_BUNDLE_VECTORS_Control()
OPENPLX_SWIG_NS_VECTORS_Control_Virtual();
%enddef

%define OPENPLX_SWIG_BUNDLE_INCLUDES_Control()
OPENPLX_SWIG_NS_INCLUDES_Control_Virtual();
%enddef

