#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Vehicles/VehiclesBundleExport.h>
#include <openplx/Vehicles/VehiclesForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/Bodies/RigidBody.h>
#include <openplx/Vehicles/Wheels/RimTrait.h>
#include <openplx/Physics3D/Geometries/Cylinder.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Rim */
namespace openplx::Vehicles::Wheels {
    class OPENPLX_Vehicles_BUNDLE_EXPORT Rim : public openplx::Physics3D::Bodies::RigidBody, public openplx::Vehicles::Wheels::RimTrait {
        protected:
            double m_radius;
            double m_width;
            std::shared_ptr<openplx::Math::Vec3> m_rotational_axis;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> m_connector;
            std::shared_ptr<openplx::Physics3D::Geometries::Cylinder> m_geometry;

        public:
            Rim();
            virtual ~Rim();
            double radius() const override;
            double width() const override;
            std::shared_ptr<openplx::Math::Vec3> rotational_axis() const override;
            std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> connector() const override;
            std::shared_ptr<openplx::Physics3D::Geometries::Cylinder> geometry() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
