#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Sensors/SensorsBundleExport.h>
#include <openplx/Sensors/SensorsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Sensors/Optics/RayEmissionDistortion.h>
#include <openplx/Math/Random/GaussianDistribution.h>
#include <openplx/Math/Vec3.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RayEmissionAngleGaussianNoise */
namespace openplx::Sensors::Optics {
    /**
     *     Distortion of the ray emission angle, as relative to the local optical system of the ray. The
     *     optical system is assumed to be right handed with the Z-axis pointing along the ray traversal
     *     direction.
     *     */
    class OPENPLX_Sensors_BUNDLE_EXPORT RayEmissionAngleGaussianNoise : public openplx::Sensors::Optics::RayEmissionDistortion {
        protected:
            std::shared_ptr<openplx::Math::Random::GaussianDistribution> m_gaussian_distribution;
            std::shared_ptr<openplx::Math::Vec3> m_rotation_axis;

        public:
            RayEmissionAngleGaussianNoise();
            virtual ~RayEmissionAngleGaussianNoise();
            std::shared_ptr<openplx::Math::Random::GaussianDistribution> gaussian_distribution() const;
            std::shared_ptr<openplx::Math::Vec3> rotation_axis() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
