#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Robotics/RoboticsBundleExport.h>
#include <openplx/Robotics/RoboticsForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Physics/Signals/Output.h>
#include <openplx/Robotics/Signals/Sensor.h>
#include <openplx/Physics/Signals/OutputSignal.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model RobotOutput */
namespace openplx::Robotics::Signals {
    /**
     * A filter that accepts signals from specified sources and composes them into a RobotOutputSignal
     * - Signal values from `sensors` will be composed into `sensor_values` with possibly multiple values under the name of the sensor.
     *
     * The following signals are unnamed, so the order is important:
     * - Signal values from `joint_sources` with type InputOutputType.Angle will be composed in order into `angles`
     * - Signal values from `joint_sources` with type InputOutputType.AngularVelocity1D will be composed in order into `angular_velocities`
     * - Signal values from `joint_sources` with type InputOutputType.Torque will be composed in order into `torques`
     * - Signal values from `object_sources` will be composed in order into `object_values`.
     *
     **/
    class OPENPLX_Robotics_BUNDLE_EXPORT RobotOutput : public openplx::Physics::Signals::Output {
        protected:
            std::vector<std::shared_ptr<openplx::Physics::Signals::Output>> m_joint_sources;
            std::vector<std::shared_ptr<openplx::Physics::Signals::Output>> m_object_sources;
            std::vector<std::shared_ptr<openplx::Robotics::Signals::Sensor>> m_sensors;

        public:
            RobotOutput();
            virtual ~RobotOutput();
            std::vector<std::shared_ptr<openplx::Physics::Signals::Output>> joint_sources() const;
            std::vector<std::shared_ptr<openplx::Physics::Signals::Output>> object_sources() const;
            std::vector<std::shared_ptr<openplx::Robotics::Signals::Sensor>> sensors() const;
            std::shared_ptr<openplx::Physics::Signals::OutputSignal> process(std::shared_ptr<openplx::Physics::Signals::Output> output, std::vector<std::shared_ptr<openplx::Physics::Signals::OutputSignal>> signals) const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
