#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics3D/Physics3DBundleExport.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics3D/Interactions/SurfaceContact/Traits/OrientedFriction.h>
#include <openplx/Physics3D/Bodies/Body.h>
/* Generated code for model BodyOrientedFriction */
namespace openplx::Physics3D::Interactions::SurfaceContact::Traits {
    /**
     *     The BodyOrientedFriction implement OrientedFriction,
     *     for the primary_direction to be relative a reference_body.
     *
     *     works with Physics.Interactions.Dissipation.DefaultDryFriction
     **/
    class OPENPLX_Physics3D_BUNDLE_EXPORT BodyOrientedFriction : public openplx::Physics3D::Interactions::SurfaceContact::Traits::OrientedFriction {
        public:
            BodyOrientedFriction();
            virtual ~BodyOrientedFriction();
            virtual std::shared_ptr<openplx::Math::Vec3> primary_direction() const = 0;
            virtual double secondary_coefficient() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Bodies::Body> reference_body() const = 0;
    };
}
