#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Physics/PhysicsBundleExport.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/Interactions/Flexibility/LinearElastic.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model PatchElasticity */
namespace openplx::Physics::Interactions::SurfaceContact {
    /**
     *         Models the interaction between two objects in contact with a unidirectional elasticity.
     *     Where the model assume contact points, where all are treated as one surface area.
     *     Compared to the PointwiseElasticity model, the stiffness of the PatchElasticity model
     *     will remain independent of the number of points.
     *     */
    class OPENPLX_Physics_BUNDLE_EXPORT PatchElasticity : public openplx::Physics::Interactions::Flexibility::LinearElastic {
        protected:

        public:
            PatchElasticity();
            virtual ~PatchElasticity();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
