
#pragma once

#include <openplx/Token.h>
#include <openplx/NodeVisitor.h>

namespace openplx
{
    class NodeToStringVisitorPrivate;

    class NodeToStringVisitor : public NodeVisitor
    {
        public:

            NodeToStringVisitor(bool sort_members = false);

            std::string result();

            void visitDocument(const DocPtr &document) override;

            void visitModelDeclaration(const ModelDeclPtr &model_declaration) override;

            void visitVarAssignment(const VarAssignPtr &var_assignment) override;

            void visitMethodDeclaration(const MethodDeclPtr &method_declaration) override;

            void visitConstant(const ConstantPtr &constant) override;

            void visitCall(const CallPtr &call) override;

            void visitMemberAccess(const MemberAccessPtr &member_access) override;

            void visitArray(const ArrayPtr &array) override;

            void visitUnary(const UnaryPtr &unary) override;

            void visitBinaryOp(const BinaryOpPtr &binary_op) override;

            void visitPrimitiveType(const PrimitiveTypePtr &primitive_type) override;

            void visitParameter(const ParamPtr &parameter) override;

            void visitIndexing(const IndexingPtr& indexing) override;

            void visitOperatorOverload(const OpOverloadPtr &op_overload) override;

            void visitAnnotation(const AnnotationPtr& annotation) override;

            ~NodeToStringVisitor();

        private:

            std::string tokenToString(const Token& token);
            std::vector<NodePtr> sortMembers(const std::vector<NodePtr>& members);
            std::vector<VarAssignPtr> sortMembers(const std::vector<VarAssignPtr>& members);
            void printSegments(const std::vector<Token>& segments);

            NodeToStringVisitorPrivate* m_private;
    };
}
