#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Connections/Pivot/Hinge.h>
#include <openplx/MachineModeling/Connections/Pivot/Traits/Axle.h>
#include <openplx/Physics3D/Interactions/Hinge.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model HingedAxle */
namespace openplx::MachineModeling::Connections::Pivot {
    /**
     *     By specializing the Hinge connection
     *     to a HingeAxle connection both objects
     *     of the Pivot connection are constrained
     *     to the axle instead of to each other.
     *
     *     It becomes natural to have this type of connection
     *     when more than two objects are pivoting about the same axis.
     *     For example when a hydraulic cylinder actuates
     *     a linked system and not the object directly.
     *
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT HingedAxle : public openplx::MachineModeling::Connections::Pivot::Hinge, public openplx::MachineModeling::Connections::Pivot::Traits::Axle {
        protected:
            std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base> m_axle;
            std::shared_ptr<openplx::Physics3D::Interactions::Hinge> m_from_hinge;
            std::shared_ptr<openplx::Physics3D::Interactions::Hinge> m_to_hinge;

        public:
            HingedAxle();
            virtual ~HingedAxle();
            std::shared_ptr<openplx::MachineModeling::Components::Primitive::Axle::Base> axle() const override;
            std::shared_ptr<openplx::Physics3D::Interactions::Hinge> from_hinge() const;
            std::shared_ptr<openplx::Physics3D::Interactions::Hinge> to_hinge() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
