#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Connections/Pivot/Base.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model Hinge */
namespace openplx::MachineModeling::Connections::Pivot {
    /**
     *     A Hinge connecion is the simplst type of Pivot connection
     *     and constrains all degrees of freedom, except the axis of rotation.
     *     Note that to prevent rotation about the two other axes,
     *     the Hinge defines constaints that will indroduce a moment.
     *
     *     To simulate a more realistic Pivot connection
     *     see the Bearings and AxleBearings variants.
     *     With them realistic Bearing forces can be computed.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT Hinge : public openplx::MachineModeling::Connections::Pivot::Base {
        protected:

        public:
            Hinge();
            virtual ~Hinge();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
