#pragma once
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/Physics3D/Interactions/MateConnector.h>
#include <openplx/Physics3D/Geometries/Cylinder.h>
/* Generated code for model RigidCylinderPart */
namespace openplx::MachineModeling::Actuators::Linear::Traits {
    /**
     *     A trait for upgrading a rigid body to
     *     one of the two parts of a Linear Cylinder Actuator.
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT RigidCylinderPart {
        public:
            RigidCylinderPart();
            virtual ~RigidCylinderPart();
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> connector() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Interactions::MateConnector> internal_connector() const = 0;
            virtual double length() const = 0;
            virtual double diameter() const = 0;
            virtual std::shared_ptr<openplx::Physics3D::Geometries::Cylinder> cylinder() const = 0;
    };
}
