#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/MachineModeling/MachineModelingBundleExport.h>
#include <openplx/MachineModeling/MachineModelingForward.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Simulation/SimulationForward.h>
#include <openplx/Visuals/VisualsForward.h>
#include <openplx/MachineModeling/Actuators/Linear/Cylinder.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model CylinderBearings */
namespace openplx::MachineModeling::Actuators::Linear {
    /**
     *     Add bearings to the cylinder.
     *     The from and to bearings are required as bearings on the
     *     components that the cylinder should connect to.
     *     The Cylinder bearings will adapt to the bearing separation
     *     on the other objects
     *     */
    class OPENPLX_MachineModeling_BUNDLE_EXPORT CylinderBearings : public openplx::MachineModeling::Actuators::Linear::Cylinder {
        protected:
            double m_barrel_separation;
            double m_rod_separation;

        public:
            CylinderBearings();
            virtual ~CylinderBearings();
            double barrel_separation() const;
            double rod_separation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
