#pragma once

#include <memory>
#include <string>
#include <openplx/control_export.h>
#include <openplx/HeapControlInterface.h>

namespace openplx {

    class JsonControlInterfaceImpl;

    class OPENPLX_CONTROL_EXPORT JsonControlInterface {
        public:
            JsonControlInterface(std::shared_ptr<HeapControlInterface> heap_control_interface);
            ~JsonControlInterface();

            void set_collapse_single_field_controls(bool collapse);

            std::string read(const std::shared_ptr<Physics::Signals::Output>& output);
            std::string decode_buffer(HeapControlInterfaceReadBuffer& buffer);
            void write(const std::shared_ptr<Physics::Signals::Input>& input, const std::string& json_str);

        private:
            JsonControlInterfaceImpl* m_impl;
    };
}
