
#pragma once

#include <memory>
#include <string>
#include <vector>
#include <openplx/Token.h>
#include <openplx/Node.h>

namespace openplx
{
    class Import : public Node, public std::enable_shared_from_this<Import>
    {
        public:
            /* Factories */
            static ImportPtr create(Token path, Token original_path, std::vector<Token> type_segments, std::vector<AnnotationPtr> annotations);

            /* Overrides */
            ImportPtr asImport() override;
            void accept(NodeVisitor& visitor) override;
            void unbind() override;

            /* Path */
            void setPathToken(Token token);
            void setOriginalPathToken(Token token);
            Token getPathToken() const;
            Token getOriginalPathToken() const;
            std::string getPath() const;

            /* Type segments */
            const std::vector<Token>& getTypeSegments() const;
            std::string typeSegmentsAsString() const;

            /* Annotations */
            const std::vector<AnnotationPtr>& getAnnotations() const;

            /* Owning document */
            DocPtr getOwningDocument() const;
            void setOwningDocument(DocPtr owning_document);
            std::string getSourceIdOrDefault() const;

            /* Utility */
            bool equivalent(const ImportPtr& other) const;

            /* Layout */
            void layout(line_t line);

        private:
            Import();
            Token m_path;
            Token m_original_path;
            std::vector<Token> m_type_segments;
            std::vector<AnnotationPtr> m_annotations;
            DocPtr m_owning_document;
    };
}
