#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/Gear.h>
#include <openplx/Physics/Interactions/Flexibility/DefaultFlexibility.h>
#include <openplx/Physics/Interactions/Dissipation/DefaultDissipation.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model FlexibleGear */
namespace openplx::DriveTrain {
    /**
     * The FlexibleGear is a rotational coupling designed to connect
     * two RotationalBodies while introducing the ability to flex under load.
     * This model incorporates parameters for stiffness and damping,
     * allowing it to absorb energy and adapt to variations in force.
     * It facilitates a linear relationship in rotational speed and position
     * between two Physics1D.Bodies.RotationalBody instances using a specified gear ratio,
     * providing resilience and adaptability compared to an ideal gear.
     **/
    class OPENPLX_DriveTrain_BUNDLE_EXPORT FlexibleGear : public openplx::DriveTrain::Gear {
        protected:
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> m_flexibility;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> m_dissipation;

        public:
            FlexibleGear();
            virtual ~FlexibleGear();
            std::shared_ptr<openplx::Physics::Interactions::Flexibility::DefaultFlexibility> flexibility() const;
            std::shared_ptr<openplx::Physics::Interactions::Dissipation::DefaultDissipation> dissipation() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
