#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/DriveTrain/MeanValueEngine.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model VolvoTD73KD */
namespace openplx::DriveTrain::Engines {
    /**
     *         Used in Volvo Wheel Loader L120D.
     *         Reference: https://www.volvoce.com/-/media/volvoce/global/global-site/product-archive/documents/spec-sheets/wheel-loaders/v-l120d-213-2321-0004.pdf?v=_nxHPw
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT VolvoTD73KD : public openplx::DriveTrain::MeanValueEngine {
        protected:

        public:
            VolvoTD73KD();
            virtual ~VolvoTD73KD();
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
