#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/DriveTrain/DriveTrainBundleExport.h>
#include <openplx/DriveTrain/DriveTrainForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics1D/Physics1DForward.h>
#include <openplx/Physics3D/Physics3DForward.h>
#include <openplx/Physics1D/Interactions/Mate.h>
#include <openplx/Physics/Signals/RelativeVelocity1DOutputTrait.h>
#include <openplx/DriveTrain/Signals/TorqueConverterLockUpInput.h>
#include <openplx/DriveTrain/Signals/TorqueConverterLockedUpOutput.h>
#include <openplx/DriveTrain/VelocityRatioTorqueMultiplicationPair.h>
#include <openplx/DriveTrain/VelocityRatioGeometryFactorPair.h>
#include <openplx/Physics/Signals/RelativeVelocity1DOutput.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model EmpiricalTorqueConverter */
namespace openplx::DriveTrain {
    /**
     *     The TorqueConverter transfers rotating power from the pump to the impeller.
     *     The model is based on the work of Eriksson and Nielsen in "Modeling and control of engines and drivelines".
     *     More specifically page 409, section 14.8.
     *
     *     The fluid coupling is modeled using two tables of empirical data.
     *     One descibing the torque multiplication of the transfered torque and
     *     the other one describing how the geometry of it affects the counter torque present in the torque converter.
     *
     *     The model is populated with default values found from Figure 14.9 in "Modeling and control of engines and drivelines".
     *
     *
     *     The oil_density and diameter parameters effect the pump torque as
     *     pump_torque = geometry_factor(velocity_ratio) * pump_vel * pump_vel * oil_density * pow(diameter, 5)
     *     turbine_torque = torque_multiplier(velocity_ratio) * pump_torque
     *     The oil_density, diameter and lock_up_time also has realistic default values, for the converter to work out of the box.
     *
     *     The converter has a lock up mechanism, and the time for enabling the mechanical lock
     *     is modeled with the lock_up_time parameter.
     *
     *     */
    class OPENPLX_DriveTrain_BUNDLE_EXPORT EmpiricalTorqueConverter : public openplx::Physics1D::Interactions::Mate, public openplx::Physics::Signals::RelativeVelocity1DOutputTrait {
        protected:
            double m_oil_density;
            double m_diameter;
            double m_lock_up_time;
            std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput> m_lock_up_input;
            std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput> m_locked_up_output;
            std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>> m_velocity_ratio_torque_multiplier_list;
            std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>> m_velocity_ratio_geometry_factor_list;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> m_factor_pair1;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> m_factor_pair2;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> m_factor_pair3;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> m_factor_pair4;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> m_factor_pair5;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> m_mult_pair1;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> m_mult_pair2;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> m_mult_pair3;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> m_mult_pair4;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> m_mult_pair5;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> m_mult_pair6;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> m_mult_pair7;
            std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput> m_slip_velocity_output;

        public:
            EmpiricalTorqueConverter();
            virtual ~EmpiricalTorqueConverter();
            double oil_density() const;
            double diameter() const;
            double lock_up_time() const;
            std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockUpInput> lock_up_input() const;
            std::shared_ptr<openplx::DriveTrain::Signals::TorqueConverterLockedUpOutput> locked_up_output() const;
            std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair>> velocity_ratio_torque_multiplier_list() const;
            std::vector<std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair>> velocity_ratio_geometry_factor_list() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> factor_pair1() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> factor_pair2() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> factor_pair3() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> factor_pair4() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioGeometryFactorPair> factor_pair5() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> mult_pair1() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> mult_pair2() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> mult_pair3() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> mult_pair4() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> mult_pair5() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> mult_pair6() const;
            std::shared_ptr<openplx::DriveTrain::VelocityRatioTorqueMultiplicationPair> mult_pair7() const;
            std::shared_ptr<openplx::Physics::Signals::RelativeVelocity1DOutput> slip_velocity_output() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
