#pragma once
#include <openplx/Object.h>
#include <openplx/ExpressionEvaluator.h>
#include <memory>
#include <stdexcept>
#include <unordered_map>
#include <openplx/Control/ControlBundleExport.h>
#include <openplx/Control/ControlForward.h>
#include <openplx/Math/MathForward.h>
#include <openplx/Physics/PhysicsForward.h>
#include <openplx/Physics/Signals/Output.h>

#ifdef _MSC_VER
#  pragma warning(push)
#  pragma warning(disable: 4251)
#endif

/* Generated code for model AffineTransform1DOutput */
namespace openplx::Control::Virtual {
    /**
     * A virtual output control that multiplies a single real field
     * from another output with a matching field with a scale factor and adds an offset.
     **/
    class OPENPLX_Control_BUNDLE_EXPORT AffineTransform1DOutput : public openplx::Physics::Signals::Output {
        protected:
            std::string m_field_name;
            double m_scale;
            double m_offset;
            std::weak_ptr<openplx::Physics::Signals::Output> m_source;

        public:
            AffineTransform1DOutput();
            virtual ~AffineTransform1DOutput();
            std::string field_name() const;
            double scale() const;
            double offset() const;
            std::shared_ptr<openplx::Physics::Signals::Output> source() const;
            void setDynamic(const std::string& key, openplx::Core::Any&& value) override;
            openplx::Core::Any getDynamic(const std::string& key) const override;
            openplx::Core::Any callDynamic(const std::string& key, const std::vector<openplx::Core::Any>& args) override;
            void extractObjectFieldsTo(std::vector<std::shared_ptr<openplx::Core::Object>>& output) const override;
            void extractEntriesTo(std::vector<std::pair<std::string, openplx::Core::Any>>& output) const override;
            void triggerOnInit(const openplx::RuntimeContext& context) override;
    };
}

#ifdef _MSC_VER
#  pragma warning(pop)
#endif
