
#pragma once

#include <vector>
#include <openplx/NodeVisitor.h>

namespace openplx {
    class BindOwningModelAndDocumentVisitor : private NodeVisitor {
        public:
            BindOwningModelAndDocumentVisitor();
            void bind(const DocPtr& document);
        private:
            void visitDocument(const DocPtr& document) override;
            void visitModelDeclaration(const ModelDeclPtr& model_declaration) override;
            void visitVarAssignment(const VarAssignPtr& var_assignment) override;
            void visitMethodDeclaration(const MethodDeclPtr& method_declaration) override;

            DocPtr m_document;
            ModelDeclPtr m_model;
            std::vector<VarAssignPtr> m_declaration_stack;
    };
}
